;#########################
;#  Kevin's Definitions  #
;#########################

#define B_CALL(xxxx)		rst 28h \ .dw xxxx
#define B_JUMP(xxxx)		call 50h \ .dw xxxx
#define SETPEN(xx,yy)		LDHL(yy,xx) \ ld (PenCol),hl
#define SETCUR(xx,yy)		LDHL(xx,yy) \ ld (currow),hl
#define DRAWHL(xx,yy)		B_CALL(_SetXXXXOP2) \ B_CALL(_Op2ToOP1) \ SETPEN(xx,yy) \ ld a,5 \ B_CALL(_DispOP1A)
#define DRAWINT(int,xx,yy)	ld hl,(int) \ DRAWHL(xx,yy)
#define DRAWTEXT(text,xx,yy)	SETPEN(xx,yy) \ ld hl,text \ B_CALL(_VPutS)
#define DRAWIMG(img,xx,yy)	ld hl,img \ LDDE(yy,xx) \ B_CALL(_DispImg)
#define LDHL(xx,yy)		.db 21h \ .db yy \ .db xx
#define LDDE(xx,yy)		.db 11h \ .db yy \ .db xx
#define LDBC(xx,yy)		.db 01h \ .db yy \ .db xx
#define LINKOUT(xx)		ld a,xx \ out (0),a
#define LINKIN(xx)		in a,(0) \ and $03 \ cp xx
#define KEY(xxxx)		ld a,xxxx>>8 \ out (1),a \ ld b,xxxx&$00FF \ in a,(1) \ cp b
#define FIND(xxxx)		ld hl,xxxx \ MOV9TOOP1() \ B_CALL(_ChkFindSym)
#define PAUSE(time)		ld b,time \ halt \ djnz $-1
#define QUICKPAUSE(time)	ld b,time \ djnz $+0
#define OP1TOOP2()		rst 08h
#define FINDSYM()		rst 10h
#define PUSHRREALO1()		rst 18h
#define MOV9TOOP1()		rst 20h
#define FPADD()			rst 30h
#define FONTSIZESMALL()		res 2,(IY+50)
#define FONTSIZELARGE()		set 2,(IY+50)
#define STARTMODES()		res 0,(IY+20) \ set 7,(IY+20) \ set 0,(IY+60) \ B_CALL(_RunIndicOff)
#define ENDMODES()		res 5,(IY+0) \ res 2,(IY+2) \ set 0,(IY+3) \ res 4,(IY+9) \ res	7,(IY+20)
#defcont			\ res 0,(IY+60) \ res 2,(IY+50) \ SETCUR(0,0) \ B_CALL(_ClrLcdFull)
#define VAR(name,size)		name: \ .org name+(size)
#define VALIDATE(last)		#if ($+0 > last) \ .echo "ERROR: MEMORY: " \ .echo ($+0 - last) \ .echo " bytes too large\n" \ ld q,q \ #endif
#define MAP(name,src,dest)	name = ($+0 - src) + dest
#define INTERRUPTENTER()	di \ ex af,af' \ exx \ push ix
#define INTERRUPTEXIT()		ld a,8 \ out (3),a \ ld a,10 \ out (3),a \ ld a,c_IntFreq \ out (4),a \ pop ix \ exx \ ex af,af' \ ei
#define COPY(src,dest,size)	ld hl,src \ ld de,dest \ ld bc,size \ ldir
#define FILLRAM(first,last,xx)	ld hl,first \ ld de,first+1 \ ld bc,last-first-1 \ ld (hl),xx \ ldir
#define ZERORAM(first,last)	FILLRAM(first,last,0)
#define MAX_A(xx)		cp xx \ jr nc,$+4 \ ld a,xx
#define MIN_A(xx)		cp xx \ jr c,$+4 \ ld a,xx
#define MAX_HL(xx)		ld a,(hl) \ cp xx \ jr nc,$+4 \ ld (hl),xx
#define MIN_HL(xx)		ld a,(hl) \ cp xx \ jr c,$+4 \ ld (hl),xx

#define DRAWC(img,Y,w,ht,buf)	ld de,buf+(Y*12)+((12-w)/2) \ ld hl,img \ ld c,12-(w) \ ld a,ht \ call DrawCentered
#define DRAWCX(img,Y,w,ht,buf)	ld de,buf+(Y*12)+((12-w)/2) \ ld hl,img \ ld c,12-(w) \ ld a,ht \ call DrawCenteredX
#define DRAW(img,Y,X,w,ht,buf)	ld de,buf+(Y*12)+(X) \ ld hl,img \ ld c,12-(w) \ ld a,ht \ call DrawCentered
#define DRAWX(img,Y,X,w,ht,buf) ld de,buf+(Y*12)+(X) \ ld hl,img \ ld c,12-(w) \ ld a,ht \ call DrawCenteredX
#define DRAWNOIMG(Y,X,w,ht,buf)	ld de,buf+(Y*12)+(X) \ ld c,12-(w) \ ld a,ht \ call DrawCentered
#define KEYSKIP(xxxx)		ld hl,v_LastKey \ ld a,(hl) \ or a \ jr z,$+9 \ call CheckAllKeys \ jr nz,xxxx \ xor a \ ld (hl),a

;########################
;#  TI-83+ Definitions  #
;########################

_ClrLcdFull	=4540h
_GetKey		=4018h
_DispImg	=4D9Bh
_RunIndicOff	=4570h
_GrBufClr	=4BD0h
_GrBufCpy	=486Ah
_SetXXXXOP2	=4792h
_OP2ToOP1	=4156h
_DispOP1A	=4BF7h
_VPutC		=455Eh
_VPutS		=4561h
_CpHLDE		=400Ch
_CreateAppVar	=4E6Ah
_ChkFindSym	=42F1h
_DelVarArc	=4FC6h
_DelVarNoArc	=4FC9h
_DispHL		=4507h
_Arc_Unarc	=4FD8h
_AppEnd		=4027h
_ReloadAppEntry	=4C36h

;###### RAM Locations ######
gbuf1		=9340h
gbuf2		=9872h
gbuf3		=86ECh
saferam1	=8A3Ah
saferam1end	=8C4Dh
flags		=89F0h
currow		=844Bh
curcol		=844Ch
PenRow		=86D8h
PenCol		=86D7h

;###### Key Codes ######
k_Clear		=$FDBF
k_Left		=$FEFD
k_Right		=$FEFB
k_Up		=$FEF7
k_Down		=$FEFE
k_2nd		=$BFDF
k_Enter		=$FDFE

;###### Linker Codes ######
set00		=$00
set0R		=$01
setL0		=$02
setLR		=$03
get00		=$03
get0R		=$02
getL0		=$01
getLR		=$00
linkmask	=$03

;###### Constants ######
c_MaxQueue	=16
c_GndHeight	=3
c_StartX	=42
c_PofWhite	=36	;about 1/7
c_PofFlash	=8	;about 1/30
c_InitDropFreq1	=12
c_InitDropFreq2	=9
c_InitDropFreq3	=14
c_BSpeed	=7
c_KillRoom	=4
c_FallHeight	=-8
c_ScoreTimer	=20
c_FlashTimer	=40
c_PyoroFall	=200
c_PyoroGmOvr	=80
c_NoteTime	=3000
c_SpitTime	=4
c_LevUpPoints	=1500
c_MaxTngSize	=15
c_TngYOffset	=64
c_Height1	=40
c_Height2	=28
c_Height3	=18
c_Height4	=6
c_ProjDY	=10

;###### Bits ######
b_UnlockTng	=0
b_UnlockProj	=1
b_UnlockPanic	=2
b_PanicMode	=4
b_MusicOn	=5
b_AutoArc	=6

;#################
;#  Dynamic RAM  #
;#################
.org saferam1

;System
VAR(v_RSeed,1)		;Random seed
VAR(v_Mode,1)		;Game mode (Pyoro 1 or 2)
VAR(v_CanSelect,1)	;True if can select menu item

;Pre-initialized Variables
VAR(v_TempHighScore,2)	;Temporary storage to comparing high scores
VAR(v_DropFreq,1)	;How frequent fruit is dropped
VAR(v_IncBgndPtr,2)	;Offset to background change indicator

TempRAM:
;Pyoro
VAR(v_TempMode,0)	;Used for sub-menus
VAR(v_PyoroXY,0)	;In order to get X and Y in one operation
VAR(v_PyoroY,1)		;Used for death falling
VAR(v_PyoroX,1)		;Position of pyoro
VAR(v_PyoroSprite,1)	;Holds pyoro sprite index and direction
VAR(v_PyoroDY,1)	;Data for Pyoro jump

;Seed Spitting
VAR(v_SpitLast,1)	;True if spit key was the last key pressed

;Tounge Stretching
VAR(v_TngData,1)	;Contains info about the tounge
VAR(v_TngSize,1)	;Length of tounge in sprites

;Projectile Launching
VAR(v_ProjXY,0)		;In order to get X and Y in one operation
VAR(v_ProjY,1)		;Y of projectile
VAR(v_ProjX,1)		;X of projectile
VAR(v_ProjDXDY,0)	;In order to get X and Y in one operation
VAR(v_ProjDY,1)		;DY of projectile
VAR(v_ProjDX,1)		;DX of projectile
VAR(v_ProjFire,1)	;True if currently in the air
VAR(v_ProjGotFruit,1)	;True if fruit obtained

;Game Variables
VAR(v_Score,2)		;Holds the score/10
VAR(v_IncScore,2)	;Holds amount of points needed before inc difficulty
VAR(v_MaxSpeed,1)	;Holds min speed of falling fruit
VAR(v_FruitInARow,1)	;Number of fruits destroyed at once
VAR(v_NewBlocks,1)	;Number of new blocks to be dropped.
VAR(v_HasDied,1)	;True if pyoro has died

;MenuStuff
VAR(v_LastKey,1)	;True if a key has been held down between menus
VAR(v_FlashTimer,1)	;Timer for flashing titles

;Music Stuff
VAR(v_LoopPtr,2)	;Pointer to start of current song
VAR(v_NotePtr,2)	;Pointer to next music note to play
VAR(v_MusicPlays,1)	;Set if music plays this itteration.

;Data Structures
VAR(v_Blocks,16)		;Array of which blocks have been destroyed
VAR(v_QueueSize,1)		;Current size of the queue
VAR(v_Queue,4*c_MaxQueue)	;Dynamic Array of all moving sprites
TempRamEnd:

SaveRAM:
;High scores and settings
VAR(v_HighScore1,2)	;Holds highscore1/10
VAR(v_HighScore2,2)	;Holds highscore2/10
VAR(v_HighScore3,2)	;Holds highscore3/10
VAR(v_Settings,1)	;Holds bits of what has been unlocked.
SaveRamEnd:

VAR(SMCram,SMCromend-SMCrom)
VALIDATE(saferam1end)

.end

;Sprite Drawing Bits:
;
;gbuf1   gbuf2		;How screen is drawn FROM the buffer
;  0       0    White
;  0       1    Gray#2
;  1       0    Gray
;  1       1    Black

; imgL    imgR		;How 8x8 sprite is copied TO the buffer
;  0       0    Alpha
;  0       1    White
;  1       0    Gray
;  1       1    Black


;Block Array:
;
;0 - Block is there.
;1 - Block is not there.
;2 - Block is falling.


;Queue Data Structure:
;
;###### BYTE 1 ######
;0 >-- Set if exploding or score sprite
;0 \
;0  |
;0  |
;0  |- X value of sprite (unsigned)
;0  |
;0  |
;0 /
;###### BYTE 2 ######
;0 \
;0  |_ Sprite index
;0  |
;0 /
;0 >-- Reset if sprite is in fast mode     \
;0 \                                        |_ Score if exploding
;0  |- Vertical speed of sprite (unsigned)  |
;0 /                                       /
;###### BYTE 3 ######
;0 \                      \
;0  |- Sprite index timer  |
;0 /                       |
;0 >-- 0=animated 1=not    |_ Timer when exploding
;0 \                       |
;0  |_ Speed timer         |
;0  |                      |
;0 /                      /
;###### BYTE 4 ######
;0 \
;0  |
;0  |
;0  |_ Y value of sprite (unsigned)
;0  |
;0  |
;0  |
;0 /


;ToungeData:
;
;0 >-- 0=2nd Key Up 1=2nd Key Down
;0 >-- 0=Extending  1=Retracting
;0 >-- 0=No fruit   1=Has fruit
;0 >-- 0=Fruit 1    1=Fruit 2
;0 \
;0  |_ Unused
;0  |
;0 /


;AppVar Settings
;
;0 >-- Acheivement #1 (Pyoro Tounge)
;0 >-- Acheivement #2 (Pyoro Egg)
;0 >-- Acheivement #3 (Panic Mode)
;0 >-- Acheivement #4 (?)
;0 >-- Panic Mode
;0 >-- Music
;0 >-- AutoArchive
;0 >-- (?)